/* ============ */
/* serldefs.h	*/
/* ============ */
/* ==================================================================== */
/*     TYPEDEFS, #DEFINES AND PROTOTYPES FOR SERIAL COLLECTOR'S TEST	*/
/* ==================================================================== */
# if defined(__SERLDEFS_H__)
#	/* Do Nothing */
# else
#	define	__SERLDEFS_H__

# if !defined(__DEFCODES)

typedef	unsigned char		UCHAR;
typedef	unsigned int		UINT;

#define	FALSE	0
#define	TRUE	1
# endif

#define MAX_CELL_XPCT		 20
#define MIN_CELL_XPCT		  5
#define	MAX_SET_SIZE		181
#define	MIN_SET_SIZE		 10

/* ------------------- */
/* FUNCTION PROTOTYPES */
/* ------------------- */
# undef F
# if defined(__STDC__) || defined(__PROTO__)
#	define  F( P )  P
# else
#	define  F( P )  ()
# endif

typedef	struct	SerialDataStru
    {
	int	SetSize;		/* # Unique Integers in Data Set*/
	int	NumCategories;		/* Number of Categories in Test	*/
	long	MinNumPairs;		/* Min # Pairs to be Generated	*/
	long	UserNumPairs;		/* Specified (Clamped) # Pairs	*/
	long	TotNumGen;		/* Cumulative Variate Count	*/
	int	UserCellExpect;		/* User Cell Expectation	*/
	int	CallStatusOK;		/* 0 = FALSE, 1 = TRUE		*/
	double	SerialChiSq;		/* Serial Chi-Square Result	*/
	int	(*RandFun) F((void));	/* Addr. of Generating Function	*/
    }
	SERIAL_DATA_STRU;

/* INDENT OFF */
extern	void	CalcSerialProbs F((int, int, double *));
extern	void	CalcMeanStdDev F((UINT, double *, double *));
extern	void	CalcSerialChiSq F((struct SerialDataStru *));
extern	UINT	GenSerialData F((struct SerialDataStru *));
extern	void	SetSerialControls F((struct SerialDataStru *));

# undef F
/* INDENT ON */

# endif				/* <<< __SERLDEFS_H__ >>> */
